/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.mounted;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.content.contraptions.components.actors.PortableStorageInterfaceMovement;
import com.simibubi.create.content.contraptions.components.deployer.DeployerFakePlayer;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.OrientedContraptionEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.ContraptionMovementSetting;
import com.simibubi.create.foundation.utility.ContraptionData;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.MutablePair;

@Mod.EventBusSubscriber
public class MinecartContraptionItem
extends Item {
    private final AbstractMinecart.Type minecartType;
    private static final DispenseItemBehavior DISPENSER_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior behaviourDefaultDispenseItem = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            double d3;
            RailShape railshape;
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            ServerLevel world = source.m_7727_();
            double d0 = source.m_7096_() + (double)direction.m_122429_() * 1.125;
            double d1 = Math.floor(source.m_7098_()) + (double)direction.m_122430_();
            double d2 = source.m_7094_() + (double)direction.m_122431_() * 1.125;
            BlockPos blockpos = source.m_7961_().m_142300_(direction);
            BlockState blockstate = world.m_8055_(blockpos);
            RailShape railShape = railshape = blockstate.m_60734_() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate.m_60734_()).getRailDirection(blockstate, (BlockGetter)world, blockpos, null) : RailShape.NORTH_SOUTH;
            if (blockstate.m_204336_(BlockTags.f_13034_)) {
                d3 = railshape.m_61745_() ? 0.6 : 0.1;
            } else {
                if (blockstate.m_60767_() != Material.f_76296_ || !world.m_8055_(blockpos.m_7495_()).m_204336_(BlockTags.f_13034_)) {
                    return this.behaviourDefaultDispenseItem.m_6115_(source, stack);
                }
                BlockState blockstate1 = world.m_8055_(blockpos.m_7495_());
                RailShape railshape1 = blockstate1.m_60734_() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate1.m_60734_()).getRailDirection(blockstate1, (BlockGetter)world, blockpos.m_7495_(), null) : RailShape.NORTH_SOUTH;
                d3 = direction != Direction.DOWN && railshape1.m_61745_() ? -0.4 : -0.9;
            }
            AbstractMinecart abstractminecartentity = AbstractMinecart.m_38119_((Level)world, (double)d0, (double)(d1 + d3), (double)d2, (AbstractMinecart.Type)((MinecartContraptionItem)stack.m_41720_()).minecartType);
            if (stack.m_41788_()) {
                abstractminecartentity.m_6593_(stack.m_41786_());
            }
            world.m_7967_((Entity)abstractminecartentity);
            MinecartContraptionItem.addContraptionToMinecart((Level)world, stack, abstractminecartentity, direction);
            stack.m_41774_(1);
            return stack;
        }

        protected void m_6823_(BlockSource source) {
            source.m_7727_().m_46796_(1000, source.m_7961_(), 0);
        }
    };

    public static MinecartContraptionItem rideable(Item.Properties builder) {
        return new MinecartContraptionItem(AbstractMinecart.Type.RIDEABLE, builder);
    }

    public static MinecartContraptionItem furnace(Item.Properties builder) {
        return new MinecartContraptionItem(AbstractMinecart.Type.FURNACE, builder);
    }

    public static MinecartContraptionItem chest(Item.Properties builder) {
        return new MinecartContraptionItem(AbstractMinecart.Type.CHEST, builder);
    }

    private MinecartContraptionItem(AbstractMinecart.Type minecartTypeIn, Item.Properties builder) {
        super(builder);
        this.minecartType = minecartTypeIn;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos blockpos;
        Level world = context.m_43725_();
        BlockState blockstate = world.m_8055_(blockpos = context.m_8083_());
        if (!blockstate.m_204336_(BlockTags.f_13034_)) {
            return InteractionResult.FAIL;
        }
        ItemStack itemstack = context.m_43722_();
        if (!world.f_46443_) {
            RailShape railshape = blockstate.m_60734_() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate.m_60734_()).getRailDirection(blockstate, (BlockGetter)world, blockpos, null) : RailShape.NORTH_SOUTH;
            double d0 = 0.0;
            if (railshape.m_61745_()) {
                d0 = 0.5;
            }
            AbstractMinecart abstractminecartentity = AbstractMinecart.m_38119_((Level)world, (double)((double)blockpos.m_123341_() + 0.5), (double)((double)blockpos.m_123342_() + 0.0625 + d0), (double)((double)blockpos.m_123343_() + 0.5), (AbstractMinecart.Type)this.minecartType);
            if (itemstack.m_41788_()) {
                abstractminecartentity.m_6593_(itemstack.m_41786_());
            }
            Player player = context.m_43723_();
            world.m_7967_((Entity)abstractminecartentity);
            MinecartContraptionItem.addContraptionToMinecart(world, itemstack, abstractminecartentity, player == null ? null : player.m_6350_());
        }
        itemstack.m_41774_(1);
        return InteractionResult.SUCCESS;
    }

    public static void addContraptionToMinecart(Level world, ItemStack itemstack, AbstractMinecart cart, @Nullable Direction newFacing) {
        CompoundTag tag = itemstack.m_41784_();
        if (tag.m_128441_("Contraption")) {
            CompoundTag contraptionTag = tag.m_128469_("Contraption");
            Direction intialOrientation = NBTHelper.readEnum(contraptionTag, "InitialOrientation", Direction.class);
            Contraption mountedContraption = Contraption.fromNBT(world, contraptionTag, false);
            OrientedContraptionEntity contraptionEntity = newFacing == null ? OrientedContraptionEntity.create(world, mountedContraption, intialOrientation) : OrientedContraptionEntity.createAtYaw(world, mountedContraption, intialOrientation, newFacing.m_122435_());
            contraptionEntity.m_20329_((Entity)cart);
            contraptionEntity.m_6034_(cart.m_20185_(), cart.m_20186_(), cart.m_20189_());
            world.m_7967_((Entity)contraptionEntity);
        }
    }

    public String m_5671_(ItemStack stack) {
        return "item.create.minecart_contraption";
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
    }

    @SubscribeEvent
    public static void wrenchCanBeUsedToPickUpMinecartContraptions(PlayerInteractEvent.EntityInteract event) {
        AbstractMinecart cart;
        AbstractMinecart.Type type;
        Entity entity = event.getTarget();
        Player player = event.getPlayer();
        if (player == null || entity == null) {
            return;
        }
        if (!((Boolean)AllConfigs.SERVER.kinetics.survivalContraptionPickup.get()).booleanValue() && !player.m_7500_()) {
            return;
        }
        ItemStack wrench = player.m_21120_(event.getHand());
        if (!AllItems.WRENCH.isIn(wrench)) {
            return;
        }
        if (entity instanceof AbstractContraptionEntity) {
            entity = entity.m_20202_();
        }
        if (!(entity instanceof AbstractMinecart)) {
            return;
        }
        if (!entity.m_6084_()) {
            return;
        }
        if (player instanceof DeployerFakePlayer) {
            DeployerFakePlayer dfp = (DeployerFakePlayer)player;
            if (dfp.onMinecartContraption) {
                return;
            }
        }
        if ((type = (cart = (AbstractMinecart)entity).m_6064_()) != AbstractMinecart.Type.RIDEABLE && type != AbstractMinecart.Type.FURNACE && type != AbstractMinecart.Type.CHEST) {
            return;
        }
        List passengers = cart.m_20197_();
        if (passengers.isEmpty() || !(passengers.get(0) instanceof OrientedContraptionEntity)) {
            return;
        }
        OrientedContraptionEntity oce = (OrientedContraptionEntity)((Object)passengers.get(0));
        Contraption contraption = oce.getContraption();
        if (ContraptionMovementSetting.isNoPickup(contraption.getBlocks().values())) {
            player.m_5661_((Component)Lang.translateDirect("contraption.minecart_contraption_illegal_pickup", new Object[0]).m_130940_(ChatFormatting.RED), true);
            return;
        }
        if (event.getWorld().f_46443_) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        contraption.stop(event.getWorld());
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> pair : contraption.getActors()) {
            MovementBehaviour movementBehaviour = AllMovementBehaviours.getBehaviour(((StructureTemplate.StructureBlockInfo)pair.left).f_74676_);
            if (!(movementBehaviour instanceof PortableStorageInterfaceMovement)) continue;
            PortableStorageInterfaceMovement psim = (PortableStorageInterfaceMovement)movementBehaviour;
            psim.reset((MovementContext)pair.right);
        }
        ItemStack generatedStack = MinecartContraptionItem.create(type, oce).m_41714_(entity.m_7770_());
        if (ContraptionData.isTooLargeForPickup(generatedStack.serializeNBT())) {
            MutableComponent message = Lang.translateDirect("contraption.minecart_contraption_too_big", new Object[0]).m_130940_(ChatFormatting.RED);
            player.m_5661_((Component)message, true);
            return;
        }
        if (contraption.getBlocks().size() > 200) {
            AllAdvancements.CART_PICKUP.awardTo(player);
        }
        player.m_150109_().m_150079_(generatedStack);
        oce.m_146870_();
        entity.m_146870_();
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }

    public static ItemStack create(AbstractMinecart.Type type, OrientedContraptionEntity entity) {
        ItemStack stack = ItemStack.f_41583_;
        switch (type) {
            case RIDEABLE: {
                stack = AllItems.MINECART_CONTRAPTION.asStack();
                break;
            }
            case FURNACE: {
                stack = AllItems.FURNACE_MINECART_CONTRAPTION.asStack();
                break;
            }
            case CHEST: {
                stack = AllItems.CHEST_MINECART_CONTRAPTION.asStack();
                break;
            }
        }
        if (stack.m_41619_()) {
            return stack;
        }
        CompoundTag tag = entity.getContraption().writeNBT(false);
        tag.m_128473_("UUID");
        tag.m_128473_("Pos");
        tag.m_128473_("Motion");
        NBTHelper.writeEnum(tag, "InitialOrientation", entity.getInitialOrientation());
        stack.m_41784_().m_128365_("Contraption", (Tag)tag);
        return stack;
    }
}

